/*
 * Decompiled with CFR 0.152.
 */
package com.shaiksphere.mindsmine.jems;

import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;

public final class NumberHelper {
    private NumberHelper() {
    }

    public static Byte getNullSafe(Byte value) {
        return value == null ? (byte)-128 : (byte)value;
    }

    public static Short getNullSafe(Short value) {
        return value == null ? (short)Short.MIN_VALUE : (short)value;
    }

    public static Long getNullSafe(Long value) {
        return value == null ? Long.MIN_VALUE : value;
    }

    public static Float getNullSafe(Float value) {
        return Float.valueOf(value == null ? Float.MIN_VALUE : value.floatValue());
    }

    public static Double getNullSafe(Double value) {
        return value == null ? Double.MIN_VALUE : value;
    }

    public static Integer getNullSafe(Integer value) {
        return value == null ? Integer.MIN_VALUE : value;
    }

    public static boolean isPerfectSquare(Byte value) {
        return NumberHelper.isPerfectSquare(NumberHelper.getNullSafe(value).longValue());
    }

    public static boolean isPerfectSquare(Short value) {
        return NumberHelper.isPerfectSquare(NumberHelper.getNullSafe(value).longValue());
    }

    public static boolean isPerfectSquare(Integer value) {
        return NumberHelper.isPerfectSquare(NumberHelper.getNullSafe(value).longValue());
    }

    public static boolean isPerfectSquare(Long value) {
        if (NumberHelper.getNullSafe(value) < 0L) {
            return false;
        }
        long sqrt = (long)Math.sqrt(value.longValue());
        return Math.pow(sqrt, 2.0) == (double)value.longValue();
    }

    public static int[] getUniqueRandomNumbers(int bound, int arraySize) {
        return NumberHelper.getUniqueRandomNumbers(0, bound, arraySize);
    }

    public static int[] getUniqueRandomNumbers(int lowerBound, int upperBound, int arraySize) {
        if (lowerBound < 0 || upperBound < 0 || arraySize < 0) {
            throw new IllegalArgumentException("Negative number is not allowed as an argument.");
        }
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("Lower Bound cannot be larger than Upper Bound.");
        }
        if (arraySize > upperBound || arraySize > upperBound - lowerBound) {
            throw new IllegalArgumentException("Not enough unique numbers available for the array size.");
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(arraySize);
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        while (hashSet.size() < arraySize) {
            hashSet.add(threadLocalRandom.nextInt(lowerBound, upperBound));
        }
        return hashSet.stream().mapToInt(Integer::intValue).toArray();
    }

    public static int getNumOfDigits(int number) {
        if (number == 0) {
            return 1;
        }
        return (int)Math.log10(Math.abs(number)) + 1;
    }
}

