/*
 * Decompiled with CFR 0.152.
 */
package com.shaiksphere.mindsmine.jems;

import java.awt.Component;
import java.io.File;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class SwingHelper {
    public static final FileNameExtensionFilter BIN_EXTENSION_FILTER = new FileNameExtensionFilter("Binary Files", "bin");
    public static final FileNameExtensionFilter TXT_EXTENSION_FILTER = new FileNameExtensionFilter("Text Files", "txt");

    private SwingHelper() {
    }

    public static Optional<File> pickFile() {
        return SwingHelper.pickFile(null);
    }

    public static Optional<File> pickFile(String dialogTitle) {
        return SwingHelper.pickFile(dialogTitle, (FileNameExtensionFilter[])null);
    }

    public static Optional<File> pickFile(String dialogTitle, FileNameExtensionFilter ... fileNameExtensionFilter) {
        return SwingHelper.pickFile(null, dialogTitle, fileNameExtensionFilter);
    }

    public static Optional<File> pickFile(Component component, String dialogTitle, FileNameExtensionFilter ... fileNameExtensionFilter) {
        return SwingHelper.useJFileChooser(component, dialogTitle, 0, fileNameExtensionFilter);
    }

    public static Optional<File> pickFolder() {
        return SwingHelper.pickFolder(null);
    }

    public static Optional<File> pickFolder(String dialogTitle) {
        return SwingHelper.pickFolder(null, dialogTitle);
    }

    public static Optional<File> pickFolder(Component component, String dialogTitle) {
        return SwingHelper.useJFileChooser(component, dialogTitle, 1, new FileNameExtensionFilter[0]);
    }

    private static Optional<File> useJFileChooser(Component component, String dialogTitle, int fileSelectionMode, FileNameExtensionFilter ... fileNameExtensionFilter) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setName("for_testing_JFileChooser");
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(fileSelectionMode);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (dialogTitle != null && !dialogTitle.isBlank()) {
            jFileChooser.setDialogTitle(dialogTitle);
        }
        if (fileNameExtensionFilter != null) {
            Stream.of(fileNameExtensionFilter).forEach(jFileChooser::addChoosableFileFilter);
        }
        jFileChooser.showOpenDialog(component);
        return Optional.ofNullable(jFileChooser.getSelectedFile());
    }

    public static void showErrorDialog(String title, String message) {
        SwingHelper.showErrorDialog(null, title, message);
    }

    public static void showErrorDialog(Component component, String title, String message) {
        SwingHelper.useJOptionPane(component, title, message, 0);
    }

    public static void showInformationDialog(String title, String message) {
        SwingHelper.showInformationDialog(null, title, message);
    }

    public static void showInformationDialog(Component component, String title, String message) {
        SwingHelper.useJOptionPane(component, title, message, 1);
    }

    public static void showWarningDialog(String title, String message) {
        SwingHelper.showWarningDialog(null, title, message);
    }

    public static void showWarningDialog(Component component, String title, String message) {
        SwingHelper.useJOptionPane(component, title, message, 2);
    }

    public static void showQuestionDialog(String title, String message) {
        SwingHelper.showQuestionDialog(null, title, message);
    }

    public static void showQuestionDialog(Component component, String title, String message) {
        SwingHelper.useJOptionPane(component, title, message, 3);
    }

    public static void showPlainDialog(String title, String message) {
        SwingHelper.showPlainDialog(null, title, message);
    }

    public static void showPlainDialog(Component component, String title, String message) {
        SwingHelper.useJOptionPane(component, title, message, -1);
    }

    private static void useJOptionPane(Component component, String title, String message, int type) {
        JOptionPane.showMessageDialog(component, message, title, type);
    }
}

