/*
 * Decompiled with CFR 0.152.
 */
package com.shaiksphere.mindsmine.jems;

import com.shaiksphere.mindsmine.jems.StringHelper;
import java.net.URI;
import java.net.URISyntaxException;

public final class URLHelper {
    private URLHelper() {
    }

    public static boolean isValidURL(String url) {
        if (StringHelper.getNullSafe(url).isBlank()) {
            return false;
        }
        try {
            URI uRI = new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public static String appendQuery(String url, String param, Object value) {
        if (!URLHelper.isValidURL(url)) {
            throw new IllegalArgumentException("Fatal Error. 'url'. Invalid URL.");
        }
        if (StringHelper.getNullSafe(param).isBlank()) {
            throw new IllegalArgumentException("Fatal Error. 'param'. Only non-empty string(s) are allowed as arguments.");
        }
        URI _uri = null;
        try {
            _uri = new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Object query = _uri.getRawQuery();
        query = StringHelper.getNullSafe((String)query).isBlank() ? param + "=" + String.valueOf(value) : (String)query + "&" + param + "=" + String.valueOf(value);
        URI _finalURI = null;
        try {
            _finalURI = new URI(_uri.getScheme(), _uri.getRawUserInfo(), _uri.getHost(), _uri.getPort(), _uri.getRawPath(), (String)query, _uri.getRawFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return _finalURI.toString();
    }
}

