/*
 * Decompiled with CFR 0.152.
 */
package com.shaiksphere.mindsmine.jems.units;

public enum MemoryUnit {
    KIBI_BYTE(1),
    MEBI_BYTE(2),
    GIBI_BYTE(3),
    TEBI_BYTE(4),
    PEBI_BYTE(5),
    EXBI_BYTE(6),
    ZEBI_BYTE(7),
    YOBI_BYTE(8);

    private static final int CONVERSION_STANDARD = 1024;
    private final int exponentValue;
    private final double byteValue;

    private MemoryUnit(int exponentValue) {
        this.exponentValue = exponentValue;
        this.byteValue = Math.pow(1024.0, exponentValue);
    }

    public double getByteValue() {
        return this.byteValue;
    }

    public static MemoryUnit extract(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative number is not allowed as an argument.");
        }
        int exponent = (int)Math.ceil(Math.log(value) / Math.log(1024.0));
        if (exponent < 1) {
            return KIBI_BYTE;
        }
        for (MemoryUnit memoryUnit : MemoryUnit.values()) {
            if (memoryUnit.exponentValue != exponent) continue;
            return memoryUnit;
        }
        return MemoryUnit.values()[MemoryUnit.values().length - 1];
    }
}

